/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.util;

import com.dahuatech.hutool.core.codec.Base64;
import com.dahuatech.icc.exception.IccException;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignUtil {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String encryptRSA(String str, String publicKey) {
        try {
            byte[] decoded = Base64.decode(publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            String outStr = Base64.encode(cipher.doFinal(str.getBytes("UTF-8")));
            return outStr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String hmacSha256(String key, String data) throws IccException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), mac.getAlgorithm());
            mac.init(signingKey);
            return SignUtil.encodeHex(mac.doFinal(data.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IccException(-1, "Fail to generate HMAC-SHA256 signature");
        }
    }

    public static String md5(String data, String charset) {
        try {
            byte[] msg = data.getBytes(charset);
            MessageDigest md = MessageDigest.getInstance("MD5");
            return SignUtil.encodeHex(md.digest(msg));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return new String(out);
    }

    public static String encryptRSANew(String str, String publicKey) {
        byte[] decoded = Base64.decode(publicKey);
        RSAPublicKey pubKey = null;
        try {
            pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
            cipher.init(1, pubKey);
            String outStr = null;
            byte[] inputArray = str.getBytes("UTF-8");
            int inputLength = inputArray.length;
            System.out.println("\u52a0\u5bc6\u5b57\u8282\u6570\uff1a" + inputLength);
            int MAX_ENCRYPT_BLOCK = 117;
            int offSet = 0;
            byte[] resultBytes = new byte[]{};
            byte[] cache = new byte[]{};
            while (inputLength - offSet > 0) {
                if (inputLength - offSet > MAX_ENCRYPT_BLOCK) {
                    cache = cipher.doFinal(inputArray, offSet, MAX_ENCRYPT_BLOCK);
                    offSet += MAX_ENCRYPT_BLOCK;
                } else {
                    cache = cipher.doFinal(inputArray, offSet, inputLength - offSet);
                    offSet = inputLength;
                }
                resultBytes = Arrays.copyOf(resultBytes, resultBytes.length + cache.length);
                System.arraycopy(cache, 0, resultBytes, resultBytes.length - cache.length, cache.length);
            }
            outStr = Base64.encode(resultBytes);
            return outStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String publickey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDBC1ltJmXhekcMFbLTXF6Fow0gT9CtGjZxy5rBBNJyGg4qToPnZ4lVrzwTOfkOEKyNHXE8oVgma1erRu8CheBysLkfFvfe+rVRBlYN3G85ZwcWutitE0/PL+3riYCfDqgRtEOqwjACyQZUukKh1Ig5zU/HRwTlb+nRXNF9rQPRnwIDAQAB";
        System.out.println(SignUtil.encryptRSANew("dahua2023", publickey));
    }
}

