/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.net;

import com.dahuatech.hutool.core.util.HexUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;

public class URLEncoder
implements Serializable {
    public static final URLEncoder DEFAULT = URLEncoder.createDefault();
    public static final URLEncoder QUERY = URLEncoder.createQuery();
    private static final long serialVersionUID = 1L;
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public URLEncoder() {
        this(new BitSet(256));
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    private URLEncoder(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    public static URLEncoder createDefault() {
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        encoder.addSafeCharacter('!');
        encoder.addSafeCharacter('$');
        encoder.addSafeCharacter('&');
        encoder.addSafeCharacter('\'');
        encoder.addSafeCharacter('(');
        encoder.addSafeCharacter(')');
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('+');
        encoder.addSafeCharacter(',');
        encoder.addSafeCharacter(';');
        encoder.addSafeCharacter('=');
        encoder.addSafeCharacter(':');
        encoder.addSafeCharacter('@');
        encoder.addSafeCharacter('/');
        return encoder;
    }

    public static URLEncoder createQuery() {
        URLEncoder encoder = new URLEncoder();
        encoder.setEncodeSpaceAsPlus(true);
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('=');
        encoder.addSafeCharacter('&');
        return encoder;
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public void removeSafeCharacter(char c) {
        this.safeCharacters.clear(c);
    }

    public void setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public String encode(String path, Charset charset) {
        int maxBytesPerChar = 10;
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            if (this.encodeSpaceAsPlus && c == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPath.append('%');
                HexUtil.appendHex(rewrittenPath, toEncode, false);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

