/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.profile;

import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.HttpRequest;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccResponse;
import com.dahuatech.icc.oauth.http.Versions;
import com.dahuatech.icc.oauth.profile.GrantType;
import com.dahuatech.icc.util.BeanUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class IccProfile {
    private static final Log logger = LogFactory.get();
    public static volatile Map<String, String> systemVersionMap = new ConcurrentHashMap<String, String>();
    public static volatile boolean inited = Boolean.FALSE;
    public static String host;
    public static String clientId;
    public static String clientSecret;
    public static GrantType grantType;
    public static String username;
    public static String password;
    public static String pwdClientId;
    public static String pwdClientSecret;
    public static String CONFIG_CLIENT_USERID;
    public static boolean CONFIG_CLIENT_USERID_ENABLE;
    private static String HTTPS_PROTOCOL;
    public static String URL_SCHEME;
    private static String HTTP_PROTOCOL;
    private final String CONFIG_HTTPS = "icc.sdk.enable.https";
    private volatile Properties configuration = new Properties();

    private IccProfile() throws ClientException {
        this.init();
    }

    public static synchronized IccProfile getInstance() {
        return ConfigurationHolder.configuration;
    }

    public synchronized void init() throws ClientException {
        if (inited) {
            return;
        }
        inited = true;
        this.loadEnvConfig();
        this.initSystemVersion();
    }

    private void loadEnvConfig() throws ClientException {
        this.loadIccSdkProperties();
        String configClientEnable = "icc.sdk.config.client.enable";
        if (this.configuration.containsKey(configClientEnable) && "false".equalsIgnoreCase(this.configuration.getProperty(configClientEnable))) {
            CONFIG_CLIENT_USERID_ENABLE = false;
        } else {
            String configClientValue = System.getProperty(configClientEnable);
            if (StrUtil.isNotBlank((CharSequence)configClientValue)) {
                CONFIG_CLIENT_USERID_ENABLE = Boolean.parseBoolean(configClientValue);
            }
        }
        String configClientUserId = "icc.sdk.config.client.userId";
        if (this.configuration.containsKey(configClientUserId)) {
            CONFIG_CLIENT_USERID = this.configuration.getProperty(configClientUserId);
        } else {
            String configUserId = System.getProperty(configClientUserId);
            if (StrUtil.isNotBlank((CharSequence)configUserId)) {
                CONFIG_CLIENT_USERID = configUserId;
            }
        }
        String configHttps = "";
        configHttps = this.configuration.containsKey("icc.sdk.enable.https") ? this.configuration.getProperty("icc.sdk.enable.https") : System.getProperty("icc.sdk.enable.https");
        if (StrUtil.isNotBlank((CharSequence)configHttps) && "false".equalsIgnoreCase(configHttps)) {
            HTTPS_PROTOCOL = HTTP_PROTOCOL;
        }
        String sdkHost = "icc.sdk.host";
        if (StrUtil.isBlank((CharSequence)host) && this.configuration.containsKey(sdkHost)) {
            host = this.configuration.getProperty(sdkHost);
        } else if (StrUtil.isBlank((CharSequence)host)) {
            host = System.getProperty(sdkHost);
        }
        URL_SCHEME = HTTPS_PROTOCOL + host;
        String sdkClientId = "icc.sdk.clientId";
        if (StrUtil.isBlank((CharSequence)clientId) && this.configuration.containsKey(sdkClientId)) {
            clientId = this.configuration.getProperty(sdkClientId);
        } else if (StrUtil.isBlank((CharSequence)clientId)) {
            clientId = System.getProperty(sdkClientId);
        }
        String sdkClientSecret = "icc.sdk.clientSecret";
        if (StrUtil.isBlank((CharSequence)clientSecret) && this.configuration.containsKey(sdkClientSecret)) {
            clientSecret = StrUtil.trim((CharSequence)this.configuration.getProperty(sdkClientSecret));
        } else if (StrUtil.isBlank((CharSequence)clientSecret)) {
            clientSecret = System.getProperty(sdkClientSecret);
        }
        String sdkPwdClientId = "icc.sdk.pwdClientId";
        if (StrUtil.isBlank((CharSequence)pwdClientId) && this.configuration.containsKey(sdkPwdClientId)) {
            pwdClientId = this.configuration.getProperty(sdkPwdClientId);
        } else if (StrUtil.isBlank((CharSequence)pwdClientId)) {
            pwdClientId = System.getProperty(sdkPwdClientId);
        }
        String sdkPwdClientSecretKey = "icc.sdk.pwdClientSecret";
        if (StrUtil.isBlank((CharSequence)pwdClientSecret) && this.configuration.containsKey(sdkPwdClientSecretKey)) {
            pwdClientSecret = this.configuration.getProperty(sdkPwdClientSecretKey);
        } else if (StrUtil.isBlank((CharSequence)pwdClientSecret)) {
            pwdClientSecret = System.getProperty(sdkPwdClientSecretKey);
        }
        String sdkUsername = "icc.sdk.username";
        if (StrUtil.isBlank((CharSequence)username) && this.configuration.containsKey(sdkUsername)) {
            username = this.configuration.getProperty(sdkUsername);
        } else if (StrUtil.isBlank((CharSequence)username)) {
            username = System.getProperty(sdkUsername);
        }
        String sdkPassword = "icc.sdk.password";
        if (StrUtil.isBlank((CharSequence)password) && this.configuration.containsKey(sdkPassword)) {
            password = this.configuration.getProperty(sdkPassword);
        } else if (StrUtil.isBlank((CharSequence)password)) {
            password = System.getProperty(sdkPassword);
        }
        String sdkGrantType = "icc.sdk.grantType";
        if (grantType == null && this.configuration.containsKey(sdkGrantType)) {
            sdkGrantType = this.configuration.getProperty(sdkGrantType);
            grantType = GrantType.valueOf(sdkGrantType);
        } else if (grantType == null && StrUtil.isNotBlank((CharSequence)System.getProperty(sdkGrantType))) {
            sdkGrantType = System.getProperty(sdkGrantType);
            grantType = GrantType.valueOf(sdkGrantType);
        }
        if (grantType == null) {
            logger.error("IccProfile grantType can not be null , please set first", new Object[0]);
        }
        if (grantType != null && grantType.equals((Object)GrantType.password) && (StrUtil.isBlank((CharSequence)username) || StrUtil.isBlank((CharSequence)password) || StrUtil.isBlank((CharSequence)pwdClientId) || StrUtil.isBlank((CharSequence)pwdClientSecret))) {
            logger.error("GrantType type [password] ,`username` or `password` `pwdClientId` or `pwdClientSecret` can not null,please set first", new Object[0]);
        }
        if (grantType != null && grantType.equals((Object)GrantType.client_credentials)) {
            logger.error("GrantType type [client_credentials]  not support", new Object[0]);
            throw new ClientException("GrantType type [client_credentials] do not support ");
        }
    }

    private void loadIccSdkProperties() {
        InputStream is = this.getClass().getResourceAsStream("/config/iccSdk.properties");
        if (is != null) {
            try {
                this.configuration.clear();
                this.configuration.load(is);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        } else {
            logger.info("can not load [classpath:resources/config/iccSdk.properties] , use DefaultClient constructor instead ", new Object[0]);
        }
    }

    private void initSystemVersion() {
        String baseVersion = null;
        String BRM_BASE_VERSION_URL = "/evo-apigw/evo-brm/version";
        try {
            String versionBody;
            Versions versions;
            HttpRequest request = HttpRequest.get((String)(URL_SCHEME + BRM_BASE_VERSION_URL));
            request.timeout(80000);
            request.setReadTimeout(80000);
            HttpResponse evoVersion = request.execute();
            if (evoVersion.getStatus() == 200 && (versions = (Versions)BeanUtil.toBean((String)(versionBody = evoVersion.body()), Versions.class)).isSuccess()) {
                baseVersion = versions.getData().getVersion();
            }
        }
        catch (Exception e) {
            logger.error("init icc subsystem version error [{}],error [{}]", new Object[]{URL_SCHEME + BRM_BASE_VERSION_URL, e});
            e.printStackTrace();
        }
        try {
            if (StrUtil.isNotBlank(baseVersion)) {
                String evoVersionBody;
                SystemVersions systemVersions;
                String BRM_VERSION_URL = "/evo-apigw/evo-brm/%S/config/get-version";
                IccHttpHttpRequest subSystemRequest = new IccHttpHttpRequest(String.format(URL_SCHEME + BRM_VERSION_URL, baseVersion));
                HttpResponse evoVersions = subSystemRequest.executeResponse();
                if (evoVersions.getStatus() == 200 && (systemVersions = (SystemVersions)BeanUtil.toBean((String)(evoVersionBody = evoVersions.body()), SystemVersions.class)).isSuccess() && systemVersions.getData() != null && systemVersions.getData().getVersionInfo().size() > 0) {
                    List<VersionInfo> versionInfos = systemVersions.getData().getVersionInfo();
                    for (VersionInfo vi : versionInfos) {
                        if (StrUtil.isBlank((CharSequence)vi.getVersion())) continue;
                        systemVersionMap.put(vi.getSystemName(), vi.getVersion());
                    }
                }
            }
        }
        catch (ClientException e) {
            logger.error("fetch subSystem version error [{}]", new Object[]{e});
            e.printStackTrace();
        }
    }

    static {
        CONFIG_CLIENT_USERID = "1";
        CONFIG_CLIENT_USERID_ENABLE = Boolean.TRUE;
        URL_SCHEME = HTTPS_PROTOCOL = "https://";
        HTTP_PROTOCOL = "http://";
    }

    static class SystemVersions
    extends IccResponse {
        private VersionInfoDO data;

        SystemVersions() {
        }

        public VersionInfoDO getData() {
            return this.data;
        }

        public void setData(VersionInfoDO data) {
            this.data = data;
        }

        @Override
        public String toString() {
            return "SystemVersions{data=" + this.data + '}';
        }

        public class VersionInfoDO {
            private List<VersionInfo> versionInfo;

            public List<VersionInfo> getVersionInfo() {
                return this.versionInfo;
            }

            public void setVersionInfo(List<VersionInfo> versionInfo) {
                this.versionInfo = versionInfo;
            }
        }
    }

    static class VersionInfo {
        private String systemName;
        private String version;

        VersionInfo() {
        }

        public String getSystemName() {
            return this.systemName;
        }

        public void setSystemName(String systemName) {
            this.systemName = systemName;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "VersionInfo{systemName='" + this.systemName + '\'' + ", version='" + this.version + '\'' + '}';
        }
    }

    private static class ConfigurationHolder {
        private static IccProfile configuration;

        private ConfigurationHolder() {
        }

        static {
            try {
                configuration = new IccProfile();
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        }
    }
}

