/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.handle;

import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.HttpRequest;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.IccHttpHttpRequest;
import com.dahuatech.icc.oauth.http.IccResponse;
import com.dahuatech.icc.oauth.http.Versions;
import com.dahuatech.icc.oauth.model.v202010.HttpConfigInfo;
import com.dahuatech.icc.util.BeanUtil;
import com.dahuatech.icc.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InitVersionProcessor {
    public static volatile Map<String, String> systemVersionMap = new ConcurrentHashMap<String, String>();
    public static Map<String, Date> hostMap = new ConcurrentHashMap<String, Date>();
    private final Log logger = LogFactory.get();

    public void initSystemVersion(HttpConfigInfo httpConfigInfo) {
        if (StringUtils.isEmpty((String)httpConfigInfo.getHost())) {
            this.logger.warn("Init version number fail, reason: host is null.", new Object[0]);
            return;
        }
        if (hostMap.get(httpConfigInfo.getHost()) != null && hostMap.get(httpConfigInfo.getHost()).after(new Date())) {
            this.logger.debug("Init version number:" + httpConfigInfo.getHost() + " not expired", new Object[0]);
            return;
        }
        this.logger.debug("Init version number:" + httpConfigInfo.getHost() + "start", new Object[0]);
        String baseVersion = null;
        String BRM_BASE_VERSION_URL = "/evo-apigw/evo-brm/version";
        try {
            String versionBody;
            Versions versions;
            HttpRequest request = HttpRequest.get((String)(httpConfigInfo.getPrefixUrl() + BRM_BASE_VERSION_URL));
            request.setConnectionTimeout(httpConfigInfo.getConnectionTimeout().intValue());
            request.setReadTimeout(httpConfigInfo.getReadTimeout().intValue());
            HttpResponse evoVersion = request.execute();
            if (evoVersion.getStatus() == 200 && (versions = (Versions)BeanUtil.toBean((String)(versionBody = evoVersion.body()), Versions.class)).isSuccess()) {
                baseVersion = versions.getData().getVersion();
            }
        }
        catch (Exception e) {
            this.logger.error("init icc subsystem version error [{}],error [{}]", new Object[]{httpConfigInfo.getPrefixUrl() + BRM_BASE_VERSION_URL, e});
            e.printStackTrace();
        }
        try {
            if (StrUtil.isNotBlank(baseVersion)) {
                String evoVersionBody;
                SystemVersions systemVersions;
                String BRM_VERSION_URL = "/evo-apigw/evo-brm/%S/config/get-version";
                IccHttpHttpRequest subSystemRequest = new IccHttpHttpRequest(String.format(httpConfigInfo.getPrefixUrl() + BRM_VERSION_URL, baseVersion));
                subSystemRequest.getHttpRequest().setConnectionTimeout(httpConfigInfo.getConnectionTimeout().intValue());
                subSystemRequest.getHttpRequest().setReadTimeout(httpConfigInfo.getReadTimeout().intValue());
                HttpResponse evoVersions = subSystemRequest.executeResponse();
                if (evoVersions.getStatus() == 200 && (systemVersions = (SystemVersions)BeanUtil.toBean((String)(evoVersionBody = evoVersions.body()), SystemVersions.class)).isSuccess() && systemVersions.getData() != null && systemVersions.getData().getVersionInfo().size() > 0) {
                    List<VersionInfo> versionInfos = systemVersions.getData().getVersionInfo();
                    for (VersionInfo vi : versionInfos) {
                        if (StrUtil.isBlank((CharSequence)vi.getVersion())) continue;
                        systemVersionMap.put(httpConfigInfo.getHost() + vi.getSystemName(), vi.getVersion());
                    }
                }
            }
        }
        catch (ClientException e) {
            this.logger.error("fetch subSystem version error [{}]", new Object[]{e});
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        hostMap.put(httpConfigInfo.getHost(), calendar.getTime());
        this.logger.debug("Init version number over, version number:{}.", new Object[]{httpConfigInfo.getHost()});
    }

    public static synchronized InitVersionProcessor getInstance() {
        return SingleHolder.INSTANCE;
    }

    private static class SingleHolder {
        public static final InitVersionProcessor INSTANCE = new InitVersionProcessor();

        private SingleHolder() {
        }
    }

    static class SystemVersions
    extends IccResponse {
        private VersionInfoDO data;

        SystemVersions() {
        }

        public VersionInfoDO getData() {
            return this.data;
        }

        public void setData(VersionInfoDO data) {
            this.data = data;
        }

        @Override
        public String toString() {
            return "SystemVersions{data=" + this.data + '}';
        }

        public class VersionInfoDO {
            private List<VersionInfo> versionInfo;

            public List<VersionInfo> getVersionInfo() {
                return this.versionInfo;
            }

            public void setVersionInfo(List<VersionInfo> versionInfo) {
                this.versionInfo = versionInfo;
            }
        }
    }

    static class VersionInfo {
        private String systemName;
        private String version;

        VersionInfo() {
        }

        public String getSystemName() {
            return this.systemName;
        }

        public void setSystemName(String systemName) {
            this.systemName = systemName;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "VersionInfo{systemName='" + this.systemName + '\'' + ", version='" + this.version + '\'' + '}';
        }
    }
}

